/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.storagenetwork.block.inventory;

import com.lothrazar.storagenetwork.api.EnumSortType;
import com.lothrazar.storagenetwork.api.ITileNetworkSync;
import com.lothrazar.storagenetwork.block.TileConnectable;
import com.lothrazar.storagenetwork.block.inventory.ContainerNetworkInventory;
import com.lothrazar.storagenetwork.registry.SsnRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class TileInventory
extends TileConnectable
implements MenuProvider,
ITileNetworkSync {
    public static final String NBT_JEI = "storagenetworkjei";
    private boolean downwards;
    private EnumSortType sort = EnumSortType.NAME;
    private boolean isJeiSearchSynced;
    private boolean autoFocus = true;

    public TileInventory(BlockPos pos, BlockState state) {
        super((BlockEntityType)SsnRegistry.Tiles.INVENTORY.get(), pos, state);
    }

    public Component m_5446_() {
        return new TranslatableComponent(this.m_58903_().getRegistryName().m_135815_());
    }

    public AbstractContainerMenu m_7208_(int i, Inventory playerInventory, Player playerEntity) {
        return new ContainerNetworkInventory(i, this.f_58857_, this.f_58858_, playerInventory, playerEntity);
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.autoFocus = compound.m_128471_("autoFocus");
        this.setDownwards(compound.m_128471_("dir"));
        this.setSort(EnumSortType.values()[compound.m_128451_("sort")]);
        if (compound.m_128441_(NBT_JEI)) {
            this.setJeiSearchSynced(compound.m_128471_(NBT_JEI));
        }
    }

    @Override
    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128379_("dir", this.isDownwards());
        compound.m_128405_("sort", this.getSort().ordinal());
        compound.m_128379_("autoFocus", this.autoFocus);
        compound.m_128379_(NBT_JEI, this.isJeiSearchSynced());
    }

    @Override
    public boolean isDownwards() {
        return this.downwards;
    }

    @Override
    public void setDownwards(boolean downwards) {
        this.downwards = downwards;
    }

    @Override
    public EnumSortType getSort() {
        return this.sort;
    }

    @Override
    public void setSort(EnumSortType sort) {
        this.sort = sort;
    }

    public boolean isJeiSearchSynced() {
        return this.isJeiSearchSynced;
    }

    @Override
    public void setJeiSearchSynced(boolean val) {
        this.isJeiSearchSynced = val;
    }

    public boolean getAutoFocus() {
        return this.autoFocus;
    }

    @Override
    public void setAutoFocus(boolean autoFocus) {
        this.autoFocus = autoFocus;
    }
}

